
# 5. The Experiment Testing

You've made it to the testing phase! It's time to see how well your malware ninja can sneak past the antivirus guards. This is where all the hard work you’ve put into creating, modifying, and disguising your malware will be tested. Will your code fool the antivirus software, or will it be caught like a raccoon raiding the garbage bin?

---

## Step 1: Test Locally in Your Virtual Machine

### **What Are We Doing?**
First, we’ll test our malware in a **controlled environment**—your virtual machine (VM). Running malware on your main computer would be like juggling chainsaws in your living room—**don’t do it!** That’s why we’re using a VM, so if something goes wrong, your actual machine stays safe and sound.

### **Steps**:

1. **Boot Up Your Virtual Machine**:
   Make sure your VM is running with your preferred antivirus software installed (remember, we used **Kaspersky** for the main experiment, but feel free to use another if you like).

2. **Transfer the Malware**:
   You’ll need to move your malware into the VM. You can either:
   - Use a **shared folder** (just make sure it’s only accessible to your VM).
   - **Drag and drop** the file into the VM if your VM settings allow it.

3. **Run the Malware**
   Inside the VM, double-click your malware file. Wait a few moments…
   - **Did anything happen?** If the antivirus flagged it right away—**busted!**
   - If not, your malware has **evaded detection** successfully! Time to celebrate your ninja skills!

4. **Check the Logs**:
   Check your antivirus software’s logs to see if it detected any suspicious activity. If the antivirus caught on to your tricks, look at the reason why—it might mention something like "malware behavior detected" or "suspicious PE header."

5. **Optional: Experiment with Different AV Software**:
   If your malware was detected, no worries! Try tweaking it a bit more (maybe add some more NOPs or modify the PE header again) and test it against a different antivirus (like **Windows Defender** or **Avast**). This is a great way to learn how each AV software works differently!

---

## Step 2: Test with VirusTotal

### **What Are We Doing?**
Now, we’ll take our malware to the **big leagues** by testing it with **VirusTotal**. VirusTotal is like a massive database of antivirus engines that will scan your malware and give you results from dozens of AV programs. It’s like throwing your ninja into a room full of security guards and seeing how many of them notice!

### **Steps**:

1. **Visit VirusTotal**:
   Head over to [VirusTotal](https://www.virustotal.com/). It’s a free service, and no sign-up is required.

2. **Upload Your Malware**:
   - Click the **“Choose File”** button and upload your malware file (the one you’ve cleverly disguised).
   - Hit **“Scan it!”** and wait for VirusTotal to do its thing.

3. **Analyze the Results**:
   VirusTotal will give you a list of antivirus engines that scanned your file, with results like **"Malicious"** or **"Clean"** next to each one.
   
   - **Victory! **: If a lot of engines say "Clean" (or at least most of them), you’ve done a great job. Your malware is sneaky! Ninja level = expert.
   - **Uh-oh! **: If many engines detect it as malicious, don’t worry—this is your chance to learn! Check which engines caught it, and what they flagged (like “PE header tampering” or “suspicious behavior”).

4. **Take Notes**:
   - Keep a record of how many antivirus engines detected your malware. This will help you compare your results after you try making more modifications (yes, you can go back and keep tweaking your code!).

5. **Optional: VirusScan**:
   You can also try using [VirusScan](https://www.virusscan.com/), which works similarly to VirusTotal but uses a different set of antivirus engines. More tests, more knowledge!

---

## Step 3: Evasion Rate Calculation

### **What Are We Doing?**
Now that you’ve tested your malware on both your local antivirus software and online engines like VirusTotal, it’s time to calculate your **evasion rate**. This is where we see just how stealthy your malware really is!

### **Steps**:

1. **Count the Total Number of Antivirus Engines**:
   Look at how many engines tested your malware on VirusTotal. Let’s say, for example, **60 antivirus engines** scanned your file.

2. **Count How Many Detected Your Malware**:
   Out of those 60, how many actually flagged your malware? Let’s say **20 engines** detected it as malicious.

3. **Do the Math**:
   Use this simple formula to calculate your evasion rate:
   ```bash
   evasion_rate = ((total_engines - detected_engines) / total_engines) * 100
   ```
   Using our example:
   ```bash
   evasion_rate = ((60 - 20) / 60) * 100 = 66.67%
   ```
   This means your malware evaded detection **66.67%** of the time—nice work!

4. **Record Your Results**:
   Make sure to jot down your evasion rate, as this will give you a benchmark for future improvements!

---

## Step 4: Debugging and Refining

### **What Are We Doing?**
No experiment is complete without some trial and error. If your malware was detected too often, don’t fret—this is a chance to learn and refine your code. You’ll be amazed at how tiny tweaks can make a big difference!

### **Steps**:

1. **Review the Logs**:
   If your malware was detected, check the logs from both your local antivirus and VirusTotal. They may give you hints on what part of your malware was flagged.

2. **Go Back to Level 2 or 4**:
   Revisit the sections where you modified the shellcode or PE header. You can try:
   - Adding more obfuscation (like extra NOPs, or changing more section names in the PE header).
   - Adjusting the **anti-dynamic analysis** techniques (like tweaking the audio or USB checks).

3. **Test Again**:
   After making changes, repeat the testing process (both in your VM and on VirusTotal). Compare your new results with the previous ones—did the detection rate improve?

---

## Step 5: Celebrate!

You’ve officially completed the full experiment, from creating malware to testing it like a pro. Whether your malware evaded detection like a ninja or got caught red-handed, you’ve learned a ton about how malware works and how antivirus software fights back. And that’s what matters most!

---

## The Big Takeaway

To sum it up:
1. **Test locally** in a virtual machine to see how your malware fares against a specific antivirus.
2. **Upload to VirusTotal** for a broader test using multiple antivirus engines.
3. **Calculate your evasion rate** to see how stealthy your malware really is.
4. **Refine and test again** if needed—practice makes perfect!
